/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.logging;

import java.io.BufferedReader;
import java.io.StringReader;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

import com.kportal.core.cluster.ClusterHelper;

/**
 * Classe utilitaire contenant les properties spécifique au logger de l'application
 */
public class LogHelper {

	/**
	 * L'extension classique d'un log.
	 */
	public static final String LOG_EXTENSION = ".log";

	/**
	 * Le chemin du dossier de log de l'appli
	 */
	public static final String PROP_LOG_PATH = "logs.path";

	/**
	 * Si {@link LogHelper#PROP_LOG_PATH} n'est pas setter dans les properties, le chemin est WEB-INF/logs
	 */
	public static final String DEFAULT_LOG_PATH = "/WEB-INF/logs";

	/**
	 * Le nom du fichier de log par défaut de l'applicatiob (webapp)
	 */
	public static final String PROP_LOG_FILE = "logs.defaultFile";

	/**
	 * La forme des logs de l'appli : date [classe du log:ligne] [level de log] message
	 */
	public static final String PROP_LOG_LAYOUT_PATTERN = "logs.layoutPattern";

	/**
	 * Le changement de nom du fichier de log après la rotation du log (par défaut, on rajoute la date à la fin du fichier)
	 */
	public static final String PROP_LOG_FILENAME_PATTERN = "logs.fileNamePattern";

	/**
	 * Le nombre en mois de conservation des logs (par défaut 6 mois)
	 */
	public static final String PROP_LOG_MAX_HISTORY = "logs.maxHistory";

	/**
	 * La taille max de conservation des logs. Elle n'est pas setter par défaut car on gère la durée de consercation
	 */
	public static final String PROP_LOG_MAX_SIZE = "logs.maxSize";

	/**
	 * Les fichiers doivent ils être cleaner au démarage de l'appli (par défaut, non setter car les applis ne redémarre pas tout le temps)
	 */
	public static final String PROP_LOG_CLEAN_HISTORY_ON_START = "logs.cleanHistoryOnStart";

	public static String getServerLogName(String name) {
		if (StringUtils.isNotBlank(ClusterHelper.getCurrentJvmRoute())) {
			return ClusterHelper.getCurrentJvmRoute() + "-" + name;
		}
		return name;
	}

	public static void logInfoFromLine(Logger logger, String texte) throws Exception {
		BufferedReader br = new BufferedReader(new StringReader(texte));
		String line = null;
		while ((line = br.readLine()) != null) {
			if (StringUtils.isNotEmpty(line)) {
				logger.info(line);
			}
		}
	}
}
