/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.resources.optimizer.manager;

import java.util.Map;
import java.util.Properties;

import ro.isdc.wro.manager.factory.ConfigurableWroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

import com.kportal.core.resources.optimizer.model.CustomGroupExtractor;
import com.kportal.core.resources.optimizer.model.CustomXmlModelFactory;
import com.kportal.core.resources.optimizer.processor.PropertyMatcherProcessor;

/**
 * Ajoute le preprocesseur {@link PropertyMatcherProcessor} à la liste des pré-processeurs à executer
 * 
 * @author olivier.camon
 * 
 */
public class CustomWroManagerFactory extends ConfigurableWroManagerFactory {

	private Properties properties;

	public Properties getProperties() {
		return properties;
	}

	public void setProperties(Properties properties) {
		this.properties = properties;
	}

	@Override
	protected Properties newConfigProperties() {
		return properties;
	}

	@Override
	protected GroupExtractor newGroupExtractor() {
		return new CustomGroupExtractor();
	}

	@Override
	protected WroModelFactory newModelFactory() {
		return new CustomXmlModelFactory();
	}

	@Override
	protected void contributePreProcessors(Map<String, ResourcePreProcessor> map) {
		map.put("propertyMatcher", new PropertyMatcherProcessor());
		super.contributePreProcessors(map);
	}
}
