/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.core.resources.optimizer.web;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.web.context.ServletContextAware;

import ro.isdc.wro.config.factory.PropertyWroConfigurationFactory;
import ro.isdc.wro.http.WroServletContextListener;

import com.kportal.core.resources.optimizer.manager.CustomWroManagerFactory;

/**
 * Initialize {@link ro.isdc.wro.http.WroServletContextListener} with IoC.
 */
public class WroServletContextListenerInitializer implements ServletContextAware, DisposableBean {

	private ServletContext servletContext;

	private WroServletContextListener wroServletContextListener;

	private CustomWroManagerFactory wroManagerFactory;

	public void setWroManagerFactory(CustomWroManagerFactory wroManagerFactory) {
		this.wroManagerFactory = wroManagerFactory;
	}

	@Override
	public void setServletContext(ServletContext servletContext) {
		this.servletContext = servletContext;
		PropertyWroConfigurationFactory propertyWroConfigurationFactory = new PropertyWroConfigurationFactory(wroManagerFactory.getProperties());
		wroServletContextListener = new WroServletContextListener();
		wroServletContextListener.setConfiguration(propertyWroConfigurationFactory.create());
		wroServletContextListener.setManagerFactory(wroManagerFactory);
		wroServletContextListener.contextInitialized(new ServletContextEvent(servletContext));
	}

	@Override
	public void destroy() throws Exception {
		wroServletContextListener.contextDestroyed(new ServletContextEvent(servletContext));
	}
}
