/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension;

import java.io.File;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.multisites.Site;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;

public class ExtensionHelper {

	public static final String EXTENSION_TEMPLATE = ".jsp";
	public static final String PATH_JSP = "/jsp";
	public static final String PATH_WEB_INF_JSP = "/WEB-INF/jsp";
	public static final String PATH_FO = "/fo";

	public static ExtensionConfigurer getExtensionConfigurer() {
		return (ExtensionConfigurer) ApplicationContextManager.getCoreContextBean(ExtensionConfigurer.ID_BEAN);
	}

	public static ExtensionManager getExtensionManager() {
		return (ExtensionManager) ApplicationContextManager.getCoreContextBean(ExtensionManager.ID_BEAN);
	}

	public static IExtension getExtension(String id) {
		return getExtensionManager().getExtension(id);
	}

	public static String getMessage(String id, String key) {
		if (StringUtils.isNotEmpty(key)) {
			String message = MessageHelper.getMessage(id, key);
			if (StringUtils.isNotEmpty(message)) {
				return message;
			}
		}
		return key;
	}

	public static CoreExtension getCoreExtension() {
		return (CoreExtension) getExtension(ApplicationContextManager.DEFAULT_CORE_CONTEXT);
	}

	public static boolean checkCoreVersion(String coreVersion) {
		boolean versionCompatible = Boolean.TRUE;
		Version v = new Version(coreVersion);
		Version core = new Version(getCoreExtension().getVersion());
		// si la version du core est bien renseignée et n'est pas égale au moins sur une version mineure
		if (v.isValid() && !core.equalsMineur(v)){
			versionCompatible = Boolean.FALSE;
		}
		return versionCompatible;
	}

	public static String getTemplateExtension(String idExtension, String pathRelatif, boolean front) {
		if(!pathRelatif.endsWith(EXTENSION_TEMPLATE)){
			pathRelatif += EXTENSION_TEMPLATE;
		}
		if (!pathRelatif.startsWith("/")){
			pathRelatif = "/" + pathRelatif;
		}
		String path = pathRelatif;
		if (front){
			ContexteUniv ctx = ContexteUtil.getContexteUniv();
			String dossierJspFo = StringUtils.EMPTY;
			if (ctx != null && ctx.getInfosSite() != null) {
				dossierJspFo = ctx.getInfosSite().getJspFo();
			}
			if (StringUtils.isEmpty(dossierJspFo)){
				dossierJspFo = Site.getSitePrincipal().getJspFo();
			}
			// on a donc normalement une url du type /WEB-INF/jsp/../fo/*.jsp
			if (path.startsWith(PATH_WEB_INF_JSP + "/") && path.contains(PATH_FO + "/")){
				// on le tranforme en /jsp/extensions/idExt/../*.jsp
				path = StringUtils.replace(path, PATH_FO + "/", "/");
				path = StringUtils.replace(path, PATH_WEB_INF_JSP + "/", WebAppUtil.getRelativeExtensionPath(StringUtils.defaultIfEmpty(idExtension,ApplicationContextManager.DEFAULT_CORE_CONTEXT))+ "/");
				path = dossierJspFo+path;
			}
			else if (path.startsWith(PATH_JSP+ "/") && !dossierJspFo.equals(PATH_JSP)) {
				path = StringUtils.replace(path, PATH_JSP, dossierJspFo);
			}
		}
		else{
			if (path.startsWith(PATH_WEB_INF_JSP + "/")){
				path = StringUtils.replace(path, PATH_WEB_INF_JSP + "/", PATH_WEB_INF_JSP + WebAppUtil.getRelativeExtensionPath(StringUtils.defaultIfEmpty(idExtension,ApplicationContextManager.DEFAULT_CORE_CONTEXT))+ "/");
			}
		}

		// si surcharge existe
		if (new File(WebAppUtil.getAbsolutePath() + path).exists()) {
			return path;
		}

		// on teste ensuite à la racine de l'extension
		if(StringUtils.isNotEmpty(idExtension) && getExtension(idExtension)!=null){
			path = getExtension(idExtension).getRelativePath() + pathRelatif;
			if (new File(WebAppUtil.getAbsolutePath() + path).exists()) {
				return path;
			}
		}

		// on test en dernier lieu le core
		if (new File(WebAppUtil.getAbsolutePath() + pathRelatif).exists()) {
			return pathRelatif;
		}

		return StringUtils.EMPTY;
	}

	public static String getTemplateExtension(String idExtension, String pathRelatif) {
		return getTemplateExtension(idExtension,pathRelatif, Boolean.TRUE);
	}

}
