/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension;

import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ExtensionListener implements ApplicationListener<ContextRefreshedEvent> {

	public ExtensionListener() {
		super();
	}

	@Override
	public void onApplicationEvent(ContextRefreshedEvent event) {
		if (event.getSource() instanceof XmlWebApplicationContext) {
			if (((XmlWebApplicationContext) event.getSource()).getDisplayName().equalsIgnoreCase("Root WebApplicationContext")) {
				ExtensionConfigurer extConfig = ExtensionHelper.getExtensionConfigurer();
				extConfig.refresh();
			}
		}
	}
}
