/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import com.kportal.extension.module.IModule;
import com.kportal.util.StatutsMessage;

/**
 * The Interface IExtension.
 */
public interface IExtension {

	static final int ETAT_NON_VALIDE = -1;

	static final int ETAT_NON_ACTIF = 0;

	static final int ETAT_ACTIF = 1;

	static final int ETAT_A_RESTAURER = -2;

	static final int TYPE_NON_PARAMETRABLE_NON_AFFICHABLE = -1;

	static final int TYPE_NON_PARAMETRABLE_AFFICHABLE = 0;

	static final int TYPE_PARAMETRABLE = 1;

	/**
	 * Sets the id.
	 * 
	 * @param name
	 *            the new id
	 */
	public void setId(String name);

	/**
	 * Gets the id.
	 * 
	 * @return the id
	 */
	public String getId();

	/**
	 * Gets the libelle.
	 * 
	 * @return the libelle
	 */
	public String getLibelle();

	public void setLibelle(String libelle);

	/**
	 * Gets the description.
	 * 
	 * @return the description
	 */
	public String getDescription();

	/**
	 * Gets the auteur.
	 * 
	 * @return the auteur
	 */
	public String getAuteur();

	/**
	 * Gets the copyright.
	 * 
	 * @return the copyright
	 */
	public String getCopyright();

	/**
	 * Gets the version.
	 * 
	 * @return the version
	 */
	public String getVersion();

	/**
	 * Gets the version.
	 * 
	 * @return the version
	 */
	public String getCoreVersion();

	/**
	 * Gets the modules.
	 * 
	 * @return the modules
	 */
	public Collection<IModule> getModules();

	/**
	 * Gets the message.
	 * 
	 * @param langue
	 *            the langue
	 * @param key
	 *            the key
	 * @return the message
	 */
	public String getMessage(Locale locale, String key);

	/**
	 * Gets all messages.
	 * 
	 * @return the messages
	 */
	public Properties getMessages(Locale locale);

	/**
	 * Gets the property.
	 * 
	 * @param key
	 *            the key
	 * @return the property
	 */
	public String getProperty(String key);

	/**
	 * Gets all properties.
	 * 
	 * @return the properties
	 */
	public Properties getProperties();

	/**
	 * Gets the relative path.
	 * 
	 * @return the relative path
	 */
	public String getRelativePath();

	/**
	 * Gets the relative path.
	 * 
	 * @return the relative path
	 */
	public void setRelativePath(String path);

	/**
	 * Gets the script sql.
	 * 
	 * @return the script sql
	 */
	public String getScriptSQL();

	/**
	 * Sets the script sql.
	 * 
	 * @param scriptSQL
	 *            the new script sql
	 */
	public void setScriptSQL(String scriptSQL);

	public int getEtat();

	public void setEtat(int etat);

	public int getType();

	public void setType(int type);

	public List<StatutsMessage> getStatuts();

	public String getLibelleAffichable(String key);

	public String getUrl();

	public String getLogo();

	public boolean isExterne();

	public void setExterne(boolean externe);

	public boolean loadSQL();
}
