/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class Version {

	private static final Logger LOGGER = LoggerFactory.getLogger(Version.class);
	int numeroMajeur = 0;
	int numeroMineur = 0;
	int numeroMaintenance = 0;

	public Version(String version) {
		if (StringUtils.isEmpty(version)){
			return;
		}
		String[] numeros = version.split("\\.");
		String numero = StringUtils.EMPTY;
		for (int i= 0;i<numeros.length;i++) {
			try{
				numero = StringUtils.substringBefore(numeros[i], "-");
				int temp = Integer.parseInt(numero);
				switch (i) {
				case 0:
					numeroMajeur = temp;
					break;
				case 1:
					numeroMineur = temp;
					break;
				case 2:
					numeroMaintenance = temp;
					break;
				default:
					break;
				}
			}catch(Exception e){
				LOGGER.error("Erreur de parsing du numéro " + numero + " de la version " + version);
			}
		}
	}

	public Version(int numeroMajeur, int numeroMineur, int numeroMaintenance) {
		this.numeroMajeur = numeroMajeur;
		this.numeroMineur = numeroMineur;
		this.numeroMaintenance = numeroMaintenance;
	}

	public boolean equalsMajeur(Version v) {
		return numeroMajeur == v.numeroMajeur;
	}

	public boolean equalsMineur(Version v) {
		return equalsMajeur(v) && numeroMineur == v.numeroMineur;
	}

	public boolean equalsMaintenance(Version v) {
		return equalsMineur(v) && numeroMaintenance == v.numeroMaintenance;
	}

	public boolean greaterMajeur(Version v) {
		return numeroMajeur > v.numeroMajeur;
	}

	public boolean greaterMineur(Version v) {
		return greaterMajeur(v) || (equalsMajeur(v) && numeroMineur > v.numeroMineur);
	}

	public boolean greaterMaintenance(Version v) {
		return greaterMineur(v) || (equalsMineur(v)  && numeroMaintenance > v.numeroMaintenance) ;
	}

	public boolean equals(Version v){
		return equalsMaintenance(v);
	}

	public boolean greater(Version v){
		return greaterMaintenance(v);
	}

	public boolean isValid() {
		return numeroMajeur > 0;
	}

}
