/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.exception;

/**
 * Created on 27/12/2015.
 * <p>Linked by CORE-1694 (néed</p>
 * @author ocamon,cpoisnel
 * @since 6.02
 */
public class NoSuchBeanException extends Exception {

    /**
     * Serial Version UID.
     */
    private static final long serialVersionUID = 7664969446734168368L;

    /**
     * No such Bean in Spring Factory.
     */
    public NoSuchBeanException() {
        super();
    }

    /**
     * No such Bean in Spring Factory, with description.
     * @param message
     * Description
     */
    public NoSuchBeanException(final String message) {
        super(message);
    }

    /**
     * No such Bean in Spring Factory, with description and parent cause
     * @param message
     * Description
     * @param cause
     * Parent cause
     */
    public NoSuchBeanException(final String message, final Throwable cause) {
        super(message, cause);
    }
}