/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.filter;

import java.util.Collection;

import javax.servlet.Filter;

import com.jsbsoft.jtf.core.ClassBeanManager;
import com.kportal.core.context.ContextLoaderListener;
import com.kportal.extension.module.AbstractBeanManager;
import com.kportal.filter.ExtensionFilter;

public class FilterDeclarationManager extends AbstractBeanManager {

	/** The Constant ID_BEAN. */
	public static final String ID_BEAN = "filterDeclarationManager";

	@Override
	public void refresh() {
		final Collection<ExtensionFilter> filterDeclarations = ClassBeanManager.getInstance().getBeanOfType(ExtensionFilter.class);
		for (final Filter filterDeclaration : filterDeclarations) {
			ContextLoaderListener.ajouterFilter(filterDeclaration);
		}
	}
}
