/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module;

import java.util.List;
import java.util.Locale;

import com.kportal.core.autorisation.Permission;
import com.kportal.extension.IExtension;
import com.kportal.util.StatutsMessage;

/**
 * The Interface IComposant.
 */
public interface IModule {

	static final int ETAT_NON_VALIDE = -1;

	static final int ETAT_NON_ACTIF = 0;

	static final int ETAT_ACTIF = 1;

	static final int ETAT_SURCHARGE = 2;

	static final int ETAT_A_RESTAURER = -2;

	static final int TYPE_NON_PARAMETRABLE_NON_AFFICHABLE = -1;

	static final int TYPE_NON_PARAMETRABLE_AFFICHABLE = 0;

	static final int TYPE_PARAMETRABLE = 1;

	/**
	 * Gets the id extension.
	 * 
	 * @return the id extension
	 */
	public String getIdExtension();

	public IExtension getExtension();

	/**
	 * Sets the id extension.
	 * 
	 * @param extension
	 *            the new id extension
	 */
	public void setIdExtension(String extension);

	/**
	 * Gets the libelle extension.
	 * 
	 * @return the libelle extension
	 */
	public String getLibelleExtension();

	/**
	 * Sets the libelle extension.
	 * 
	 * @param libelle
	 *            the new libelle extension
	 */
	public void setLibelleExtension(String libelle);

	/**
	 * Gets the permissions.
	 * 
	 * @return the permissions
	 */
	public List<Permission> getPermissions();

	/**
	 * Gets the id.
	 * 
	 * @return the id
	 */
	public String getId();

	/**
	 * Sets the id.
	 * 
	 * @param id
	 *            the new id
	 */
	public void setId(String id);

	/**
	 * Sets the libelle.
	 * 
	 * @param Libelle
	 *            the new libelle
	 */
	public void setLibelle(String Libelle);

	/**
	 * Gets the description.
	 * 
	 * @return the description
	 */
	public String getDescription();

	/**
	 * Gets the libelle.
	 * 
	 * @return the libelle
	 */
	public String getLibelle();

	public String getLibelleAffichable();

	public int getEtat();

	public void setEtat(int etat);

	public int getType();

	public void setType(int type);

	/**
	 * Gets the message.
	 * 
	 * @param langue
	 *            the langue
	 * @param key
	 *            the key
	 * @return the message
	 */
	public String getMessage(Locale locale, String key);

	public String getMessage(String key);

	/**
	 * Gets the property.
	 * 
	 * @param key
	 *            the key
	 * @return the property
	 */
	public String getProperty(String key);

	public List<StatutsMessage> getStatuts();

	public String getUrl();
}
