/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.core.context.BeanUtil;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;

public class ModuleHelper {

	public static ModuleManager getModuleManager() {
		return (ModuleManager) ApplicationContextManager.getCoreContextBean(ModuleManager.ID_BEAN);
	}

	public static IExtension getExtensionModule(IModule module) {
		return ExtensionHelper.getExtensionManager().getExtension(module.getIdExtension());
	}

	/** retourne un module chargé avec l'id extension et id bean */
	public static IModule getModule(String idExtension, String idBean) {
		return getModuleManager().getModules().get(BeanUtil.getBeanKey(idBean, idExtension));
	}

	/** retourne un module chargé uniquement avec l'id du bean */
	public static IModule getModule(String idBean){
		// recherche du bean
		for (String key : getModuleManager().getModules().keySet()){
			if (idBean.equals(BeanUtil.getIdBeanFromKey(key))){
				return getModuleManager().getModules().get(key);
			}
		}
		return null;
	}

	public static String getRelativePathExtension(IModule module) {
		return (getExtensionModule(module)).getRelativePath();
	}
}
