/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.bean;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.univ.objetspartages.bean.MediaBean;
import com.univ.objetspartages.bean.RessourceBean;

@JsonSerialize(include = JsonSerialize.Inclusion.NON_EMPTY)
public class PluginFicheBeanExport<T extends Serializable> extends AbstractBeanExport<T> {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7624898944847722776L;

	public String classeObjet;

	private Map<String, MediaBean> medias;

	private List<RessourceBean> ressources;

	public Map<String, MediaBean> getMedias() {
		return medias;
	}

	public void setMedias(Map<String, MediaBean> medias) {
		this.medias = medias;
	}

	public List<RessourceBean> getRessources() {
		return ressources;
	}

	public void setRessources(List<RessourceBean> ressources) {
		this.ressources = ressources;
	}

	public String getClasseObjet() {
		return classeObjet;
	}

	public void setClasseObjet(String classeObjet) {
		this.classeObjet = classeObjet;
	}
}
