/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.composant;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kportal.core.autorisation.util.PermissionUtil;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.ModuleHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.PermissionBean;

public class ComposantProfil extends ComposantAdministration {

	public static final String ID_BEAN = "composantProfil";

	@Override
	public boolean isVisible(final AutorisationBean autorisation) {
		boolean isVisible = Boolean.FALSE;
		if (isAccessibleBO() && autorisation != null) {
			isVisible = autorisation.possedePermission(getPermissionGestion());
		}
		return isVisible;
	}

	@Override
	public boolean isActionVisible(final AutorisationBean autorisation, final String code) {
		return isVisible(autorisation);
	}

	/**
	 * La permission permettant de lister les utilisateurs
	 */
	public static final String CODE_PERMISSION = "profil";

	/**
	 * La permission permettant de gérer les utilisateur (Create Update Delete)
	 */
	public static final String CODE_ACTION_GESTION = "G";

	public static IModule getModule() {
		return ModuleHelper.getModule(ApplicationContextManager.DEFAULT_CORE_CONTEXT, ID_BEAN);
	}

	/**
	 * Retourne la permission de gestion des utilisateurs.
	 */
	public static PermissionBean getPermissionGestion() {
		return PermissionUtil.getPermissionBean(getModule(), CODE_PERMISSION, CODE_ACTION_GESTION);
	}

	/**
	 * En fonction des autorisations et de l'action fourni on retourne vrai si l'utilisateur a les droits en fonction de l'action qu'il entreprend.
	 */
	public static boolean isAutoriseParActionProcessus(final AutorisationBean autorisations, final String action) {
		return autorisations != null && (autorisations.isWebMaster() || autorisations.possedePermission(getPermissionGestion()));
	}
}
