/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.composant;

import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.PermissionBean;

public class ComposantRubrique extends Composant {

	@Override
	public boolean isVisible(final AutorisationBean autorisation) {
		return autorisation != null && autorisation.isAdministrateurRubrique();
	}

	@Override
	public boolean isActionVisible(final AutorisationBean autorisation, final String code) {
		if (!isVisible(autorisation)) {
			return Boolean.FALSE;
		}
		boolean isActionVisible = Boolean.FALSE;
		if (isActionCreation(code)) {
			isActionVisible = autorisation.possedePermission(new PermissionBean("TECH", "rub", "C"));
		} else {
			isActionVisible = autorisation.possedePermission(new PermissionBean("TECH", "rub", "M"));
			if (!isActionVisible) {
				isActionVisible = autorisation.possedePermission(new PermissionBean("TECH", "rub", "S"));
			}
		}
		return isActionVisible;
	}

	private boolean isActionCreation(final String code) {
		return "AJOUTER".equals(code);
	}
}
