/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.composant;

import java.util.List;

import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.extension.module.IModule;
import com.univ.objetspartages.om.AutorisationBean;

public interface IComposant extends IModule {

	public String getIdMenuBoParent();

	public boolean isVisible(AutorisationBean autorisation);

	public String getUrlAccueilBo();

	public int getOrdre();

	public String getParametreProcessus();

	public List<ActionComposant> getActions();

	public boolean isActionVisible(AutorisationBean autorisation, String code);

	public Menu getMenuAccueil(AutorisationBean autorisation);

	public String getLibelleMenu();

	public Menu getMenuGeneral(AutorisationBean autorisation, InfoBean infoBean);
}
