/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.objetspartages;

import java.util.List;
import java.util.Map;

import com.kportal.extension.module.plugin.IPlugin;
import com.kportal.extension.module.plugin.objetspartages.om.ObjetPluginContenu;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;

/**
 * The Interface IPluginContenu.
 */
public interface IPluginFiche extends IPlugin {

	/**n
	 * Preparer principal.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ficheUniv
	 *            the fiche univ
	 * @param meta
	 *            the meta
	 * @throws Exception
	 *             the exception
	 */
	public void preparerPrincipal(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception;

	/**
	 * Traiter principal.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ficheUniv
	 *            the fiche univ
	 * @param meta
	 *            the meta
	 * @throws Exception
	 *             the exception
	 */
	public void traiterPrincipal(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception;

	/**
	 * Traiter pre principal pre processor au traitement principal.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ficheUniv
	 *            the fiche univ
	 * @throws Exception
	 *             the exception
	 */
	public void preTraiterPrincipal(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception;

	/**
	 * Traiter post principal post processor au traitement principal.
	 * 
	 * @param infoBean
	 *            the info bean
	 * @param ficheUniv
	 *            the fiche univ
	 * @throws Exception
	 *             the exception
	 */
	public void postTraiterPrincipal(Map<String, Object> infoBean, FicheUniv ficheUniv, Metatag meta) throws Exception;

	/**
	 * Traiter suppression.
	 * 
	 * @param ficheUniv
	 *            the fiche univ
	 * @param meta
	 *            the meta
	 * @throws Exception
	 *             the exception
	 */
	public void supprimerObjets(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception;

	/**
	 * Traiter suppression.
	 * 
	 * @param ficheUniv
	 *            the fiche univ
	 * @param meta
	 *            the meta
	 * @throws Exception
	 *             the exception
	 */
	public void synchroniserObjets(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception;

	/**
	 * Lire donnees.
	 * 
	 * @param ficheUniv
	 *            the fiche univ
	 * @param meta
	 *            the meta
	 * @param classeObjet
	 *            la classe de l'objet
	 * @throws Exception
	 *             the exception
	 */
	public List<ObjetPluginContenu> lireObjets(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception;

	/**
	 * prepare les donnees dans le contexte pour affichage en front.
	 * 
	 * @param ficheUniv
	 *            the fiche univ
	 * @param meta
	 *            the meta
	 * @param classeObjet
	 *            la classe de l'objet
	 * @throws Exception
	 *             the exception
	 */
	public void setDataContexteUniv(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception;

	/**
	 * prepare les donnees dans le contexte pour affichage en front.
	 *
	 */
	public Object getDataContexteUniv();

	/**
	 * ajouter donnees.
	 * 
	 * @param ficheUniv
	 *            the fiche univ
	 * @param meta
	 *            the meta
	 * @param listeObjet
	 *            liste des sous objets
	 * @throws Exception
	 *             the exception
	 */
	public void ajouterObjets(FicheUniv ficheUniv, Metatag meta, List<ObjetPluginContenu> listeObjet, String classeObjet) throws Exception;

	/**
	 * dupliquer donnees.
	 * 
	 * @param ficheUniv
	 *            the fiche univ
	 * @param meta
	 *            the meta
	 * @param oldIdMeta
	 *            liste des sous objets
	 * @param classeObjet
	 *            La classe de l'objet
	 * @throws Exception
	 *             the exception
	 */
	public void dupliquerObjets(FicheUniv ficheUniv, Metatag meta, Long oldIdMeta, String classeObjet) throws Exception;

	public List<String> getObjets();

	public List<String> getClasses();

	/**
	 * Check classe.
	 * 
	 * @param name
	 *            the name of the parent class
	 * @return the boolean
	 */
	public boolean isActive(String name);

	/**
	 * Check objet.
	 * 
	 * @param objet
	 *            the name of the parent class
	 * @return the boolean
	 */
	public boolean hasObjet(String objet);

	/**
	 * Gets the path saisie bo.
	 * 
	 * @return the path saisie bo
	 */
	public String getPathSaisieBo();

	/**
	 * Gets the path saisie fo.
	 * 
	 * @return the path saisie fo
	 */
	public String getPathSaisieFo();

	/**
	 * Gets the path saisie fo.
	 * 
	 * @return the path saisie fo
	 */
	public String getPathTemplateFo();
}
