/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.objetspartages;

import java.util.List;
import java.util.Map;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.textsearch.ResultatRecherche;
import com.kportal.extension.module.plugin.IPlugin;

/**
 * The Interface IPluginRequete.
 */
public interface IPluginRecherche extends IPlugin {

	/**
	 * Checks if is actif.
	 * 
	 * @param requete
	 *            the requete
	 * @return true, if is actif
	 */
	public boolean isActif(String requete);

	/**
	 * Checks if is exclusif.
	 * 
	 * @return true, if is exclusif
	 */
	public boolean isExclusif();

	/**
	 * Annule critere nombre.
	 * 
	 * @param requete
	 *            the requete
	 * @return true, if successful
	 */
	public boolean annuleCritereNombre(String requete);

	/**
	 * Preparer requete.
	 */
	public String preparerRequete(OMContext ctx, String requete) throws Exception;

	/**
	 * Preparer recherche.
	 */
	public Map<String, Object> preparerRecherche(OMContext ctx, Map<String, Object> infoBean) throws Exception;

	/**
	 * Preparer requete.
	 */
	public Map<String, Object> taiterRecherche(OMContext ctx, Map<String, Object> infoBean) throws Exception;

	/**
	 * Traiter requete.
	 * 
	 * @param ctx
	 *            the ctx
	 * @param requete
	 *            the requete
	 * @param res
	 *            the res
	 * @return the list
	 * @throws Exception
	 *             the exception
	 */
	public List<ResultatRecherche> traiterRequete(OMContext ctx, String requete, List<ResultatRecherche> res) throws Exception;

	/**
	 * Check classes.
	 * 
	 * @param name
	 *            the name
	 * @return the boolean
	 */
	public boolean checkClasse(String name);

	/**
	 * Renvoie le path vers le template jsp incluant des champs de recherche
	 * @return le path
	 */
	public String getPathRechercheBo();

	/**
	 * Renvoie la liste des criteres de recherche
	 * @return le path
	 */
	public List<String> getCriteresRequete();
}
