/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.objetspartages;

import java.util.List;

import com.kportal.extension.module.plugin.objetspartages.om.ObjetPluginContenu;
import com.univ.objetspartages.om.FicheObjet;
import com.univ.objetspartages.om.FicheObjetHelper;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.utils.ContexteDao;
import com.univ.utils.FicheUnivMgr;

public class PluginFicheObjet extends DefaultPluginFiche {

	/**
	 * méthode pour supprimer les objets utilisés par le plugin
	 */
	@Override
	public void supprimerObjets(final FicheUniv ficheUniv, final Metatag meta, final String classeObjet) throws Exception {
		try (ContexteDao ctx = new ContexteDao()) {
			FicheObjetHelper.deleteAll(ctx, classeObjet, meta.getIdMetatag());
		}
	}

	/**
	 * méthode pour synchroniser les objets utilisés par le plugin
	 */
	@Override
	public void synchroniserObjets(final FicheUniv ficheUniv, final Metatag meta, final String classeObjet) throws Exception {
		super.synchroniserObjets(ficheUniv, meta, classeObjet);
		try (ContexteDao ctx = new ContexteDao()) {
			FicheObjetHelper.updateAll(ctx, ficheUniv, classeObjet, meta.getIdMetatag());
		}
	}

	/**
	 * méthode pour créer les objets utilisés par le plugin et leurs métas associés
	 */
	@SuppressWarnings("deprecation")
	@Override
	public void ajouterObjets(final FicheUniv ficheUniv, final Metatag meta, final List<ObjetPluginContenu> listeObjet, final String classeObjetCible) throws Exception {
		for (final String classeObjet : super.getListeObjets(classeObjetCible)) {
			for (final ObjetPluginContenu objetPluginContenu : listeObjet) {
				if (objetPluginContenu != null && objetPluginContenu.getClass().getName().equals(classeObjet)) {
					try (ContexteDao ctx = new ContexteDao()) {
						objetPluginContenu.setIdMeta(meta.getIdMetatag());
						objetPluginContenu.setCtx(ctx);
						objetPluginContenu.add();
						if (objetPluginContenu instanceof FicheObjet) {
							final Metatag metatag = FicheUnivMgr.creerMeta((FicheObjet) objetPluginContenu);
							metatag.setMetaSourceImport(meta.getMetaSourceImport());
							FicheUnivMgr.enregistrerMeta(metatag);
						}
					}
				}
			}
		}
	}
}
