/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.objetspartages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.extension.module.ModuleHelper;
import com.kportal.frontoffice.util.JSPIncludeHelper;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ContexteUtil;
import com.univ.utils.RequeteUtil;

public class PluginRechercheHelper {

	public static Collection<IPluginRecherche> getPlugins() {
		return ModuleHelper.getModuleManager().getModules(IPluginRecherche.class);
	}

	public static IPluginRecherche getPluginActif(final String requete) {
		final String objet = RequeteUtil.renvoyerParametre(requete, "OBJET");
		final Object object = ReferentielObjets.instancierObjet(objet);
		if (object != null) {
			for (final IPluginRecherche plugin : getPlugins()) {
				if (plugin.checkClasse(object.getClass().getName())) {
					if (plugin.isActif(requete)) {
						return plugin;
					}
				}
			}
		}
		return null;
	}

	public static void traiterRecherche(final OMContext ctx, final InfoBean infoBean) throws Exception {
		final String objet = infoBean.getString("CODE_OBJET");
		final Object object = ReferentielObjets.instancierObjet(objet);
		for (final IPluginRecherche plugin : getPlugins()) {
			if (plugin.checkClasse(object.getClass().getName())) {
				final Map<String, Object> map = infoBean.getValues();
				plugin.taiterRecherche(ctx, map);
				infoBean.setValues(map);
			}
		}
	}

	public static void preparerRecherche(final OMContext ctx, final InfoBean infoBean) throws Exception {
		final String objet = infoBean.getString("CODE_OBJET");
		final Object object = ReferentielObjets.instancierObjet(objet);
		for (final IPluginRecherche plugin : getPlugins()) {
			if (plugin.checkClasse(object.getClass().getName())) {
				final Map<String, Object> map = infoBean.getValues();
				plugin.preparerRecherche(ctx, map);
				infoBean.setValues(map);
			}
		}
	}

	public static List<String> getCriteresRequete(final String objet) {
		final List<String> criteres = new ArrayList<>();
		final Object object = ReferentielObjets.instancierObjet(objet);
		for (final IPluginRecherche plugin : getPlugins()) {
			if (plugin.checkClasse(object.getClass().getName())) {
				criteres.addAll(plugin.getCriteresRequete());
			}
		}
		return criteres;
	}

	public static void includePluginRechercheBo(final JspWriter out, final ServletContext context, final HttpServletRequest request, final HttpServletResponse response,
		final String objet, final boolean listeIncluse) {
		ContexteUtil.getContexteUniv().getDatas().put("listeIncluse", listeIncluse);
		final Object object = ReferentielObjets.instancierObjet(objet);
		for (final IPluginRecherche plugin : getPlugins()) {
			if (plugin.checkClasse(object.getClass().getName())) {
				JSPIncludeHelper.includeExtensionTemplate(out, context, request, response, plugin.getIdExtension(), plugin.getPathRechercheBo());
			}
		}
	}
}
