/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.objetspartages;

import java.util.Collection;
import java.util.Map;

import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.extension.module.ModuleHelper;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;

/**
 * The Class PluginContenuManager.
 */
public class PluginSaisieFicheHelper {

	public static Collection<IPluginSaisieFiche> getPlugins() {
		return ModuleHelper.getModuleManager().getModules(IPluginSaisieFiche.class);
	}

	/**
	 * Traiter pre action. Pre processor au traitement action par defaut
	 *
	 * @param infoBean
	 *            the info bean
	 * @param ficheUniv
	 *            the fiche univ
	 * @throws Exception
	 *             the exception
	 */
	public static void preTraiterAction(final InfoBean infoBean, final FicheUniv ficheUniv, final Metatag meta) throws Exception {
		for (final IPluginSaisieFiche plugin : getPlugins()) {
			final Map<String, Object> map = infoBean.getValues();
			plugin.preTraiterAction(map, ficheUniv, meta);
			infoBean.setValues(map);
		}
	}

	/**
	 * Traiter action. Pre processor au traitement action par defaut
	 *
	 * @param infoBean
	 *            the info bean
	 * @param ficheUniv
	 *            the fiche univ
	 * @throws Exception
	 *             the exception
	 */
	public static void traiterAction(final InfoBean infoBean, final FicheUniv ficheUniv, final Metatag meta) throws Exception {
		for (final IPluginSaisieFiche plugin : getPlugins()) {
			final Map<String, Object> map = infoBean.getValues();
			plugin.traiterAction(map, ficheUniv, meta);
			infoBean.setValues(map);
		}
	}

	/**
	 * Traiter post action. Post processor au traitement action par defaut
	 *
	 * @param infoBean
	 *            the info bean
	 * @param ficheUniv
	 *            the fiche univ
	 * @throws Exception
	 *             the exception
	 */
	public static void postTraiterAction(final InfoBean infoBean, final FicheUniv ficheUniv, final Metatag meta) throws Exception {
		for (final IPluginSaisieFiche plugin : getPlugins()) {
			final Map<String, Object> map = infoBean.getValues();
			plugin.postTraiterAction(map, ficheUniv, meta);
			infoBean.setValues(map);
		}
	}
}
