/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.objetspartages.om;

import java.util.Collection;

import org.codehaus.jackson.annotate.JsonIgnore;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.objetspartages.om.FicheUniv;

/**
 * Interface decrivant un sous-objet. Un sous objet doit être utilisé encapsulé dans un objet k-portal et sera automatiquement mis à jour par le framework en même temps que l'objet
 * principal
 */
public interface ObjetPluginContenu extends Cloneable {

	/**
	 * Gets the id fiche parent.
	 * 
	 * @return the id fiche parent
	 */
	public Long getIdMeta();

	/**
	 * Sets the id fiche parent.
	 * 
	 * @param _idMeta
	 *            the new id fiche parent
	 */
	public void setIdMeta(Long _idMeta);

	/**
	 * Sets the ctx.
	 * 
	 * @param ctx
	 *            the new ctx
	 */
	@Deprecated
	public void setCtx(OMContext ctx);

	/**
	 * Adds the.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Deprecated
	public void add() throws Exception;

	/**
	 * update .
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Deprecated
	public void update() throws Exception;

	/**
	 * Delete.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Deprecated
	public void delete() throws Exception;

	/**
	 * Select.
	 * 
	 * @param s
	 *            the s
	 * 
	 * @return the int
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Deprecated
	public int select(String s) throws Exception;

	/**
	 * Retrieve.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Deprecated
	public void retrieve() throws Exception;

	/**
	 * Next item.
	 * 
	 * @return true, if successful
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Deprecated
	public boolean nextItem() throws Exception;

	/**
	 * Inits the.
	 */
	@Deprecated
	public void init();

	/**
	 * Gets the id fiche.
	 * 
	 * @return the id fiche
	 */
	@JsonIgnore
	public Long getIdObjet();

	/**
	 * Sets the id objet.
	 * 
	 * @param idObjet
	 *            the new id objet
	 */
	@JsonIgnore
	public void setIdObjet(Long idObjet);

	/**
	 * Gets the cle. la cle permet les synchronisations au niveau des imports XML
	 * 
	 * @return the cle
	 */
	public String getCle();

	/**
	 * Renvoyer fiche parente.
	 * 
	 * @return the fiche univ
	 * @throws Exception
	 *             the exception
	 */
	public FicheUniv renvoyerFicheParente() throws Exception;

	/**
	 * Clone objet.
	 * 
	 * @return the objet plugin contenu
	 */
	@Deprecated
	public ObjetPluginContenu cloneObjet();

	public int selectByMeta(Long idMetatag) throws Exception;

	public Collection<SousObjet> getSousObjets();
}
