/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.rubrique;

import java.io.Serializable;
import java.util.Map;

import com.kportal.extension.module.DefaultModuleImpl;

public abstract class DefaultPageAccueilRubrique extends DefaultModuleImpl implements IPageAccueilRubrique, Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -9174663209559535271L;

	String typeRubrique = "";

	String pathSaisieBo = "";

	String pathSaisieFo = "";

	String classeBeanPageAccueil = "";

	boolean interne = true;

	@Override
	public String getTypeRubrique() {
		return typeRubrique;
	}

	@Override
	public String getPathSaisieBO() {
		return pathSaisieBo;
	}

	@Override
	public String getPathSaisieFO() {
		return pathSaisieFo;
	}

	public void setPathSaisieBo(final String pathSaisieBo) {
		this.pathSaisieBo = pathSaisieBo;
	}

	public void setPathSaisieFo(final String pathSaisieFo) {
		this.pathSaisieFo = pathSaisieFo;
	}

	public void setTypeRubrique(final String typeRubrique) {
		this.typeRubrique = typeRubrique;
	}

	@Override
	public abstract void preparerPRINCIPAL(Map<String, Object> infoBean, BeanPageAccueil bean) throws Exception;

	@Override
	public abstract void traiterPRINCIPAL(Map<String, Object> infoBean, BeanPageAccueil bean) throws Exception;

	@Override
	public String getClasseBeanPageAccueil() {
		return classeBeanPageAccueil;
	}

	public void setClasseBeanPageAccueil(final String classeBeanPageAccueil) {
		this.classeBeanPageAccueil = classeBeanPageAccueil;
	}

	@Override
	public boolean isInterne(final BeanPageAccueil bean) {
		return interne;
	}

	public void setInterne(final boolean interne) {
		this.interne = interne;
	}
}
