/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.rubrique;

import java.util.Map;

import com.kportal.extension.module.plugin.IPlugin;


public interface IPageAccueilRubrique extends IPlugin{

	/**
	 * Renvoie la clé du type
	 * @return le type
	 */
	public String getTypeRubrique();

	/**
	 * Renvoie le path vers le template jsp de saisie spécifique au type
	 * Utilisé en BO dans rubrique_saisie.jsp
	 * @return le path
	 */
	public String getPathSaisieBO();

	/**
	 * Renvoit le path vers la jsp de saisie en BO
	 * Non utilisé pour le moment
	 * @return le path
	 */
	public String getPathSaisieFO();

	/**
	 * Traitement préalable à la saisie de rubrique en fonction du type
	 * Appel dans le processus de saisie de rubrique
	 * @param infoBean
	 * @param rubrique
	 * @throws Exception
	 */
	public void preparerPRINCIPAL(Map<String, Object> infoBean, BeanPageAccueil bean) throws Exception;

	/**
	 * Traitement à l'enregistrement spécifique
	 * Appel dans le processus de saisie de rubrique
	 * @param infoBean
	 * @param rubrique
	 * @throws Exception
	 */
	public void traiterPRINCIPAL(Map<String, Object> infoBean, BeanPageAccueil bean) throws Exception;

	public String getClasseBeanPageAccueil();

	public boolean isInterne(BeanPageAccueil bean);

}
