/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.rubrique;

import java.util.Hashtable;
import java.util.Map;

import com.kportal.cms.objetspartages.Objetpartage;
import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ContexteUtil;
import com.univ.utils.UnivWebFmt;

public class ListeFichePageAccueilRubrique extends DefaultPageAccueilRubrique {

	/**
	 *
	 */
	private static final long serialVersionUID = -6558789002484644694L;

	public static class BeanListeFichePageAccueil implements BeanPageAccueil {

		private String objet = "";

		@Override
		public String getUrlRubrique(final String codeRubrique, final String langue, final boolean ampersands) throws Exception {
			final String esperluette = (ampersands ? "&amp;" : "&");
			return UnivWebFmt.determinerUrlFiche(ContexteUtil.getContexteUniv(), objet,
				"CODE_RUBRIQUE=" + codeRubrique + esperluette + "LANGUE=" + langue + esperluette + "AFFICHAGE_DOSSIER=1", ampersands);
		}

		@Override
		public String getUrlModification(final String codeRubrique, final String langue, final boolean ampersands) throws Exception {
			return "";
		}

		@Override
		public String getLibelleAffichable() {
			return ReferentielObjets.getLibelleObjet(objet);
		}

		public String getObjet() {
			return objet;
		}
	}

	@Override
	public void preparerPRINCIPAL(final Map<String, Object> infoBean, final BeanPageAccueil bean) throws Exception {
		final BeanListeFichePageAccueil b = (BeanListeFichePageAccueil) bean;
		if (StringUtils.isNotEmpty(b.objet)) {
			infoBean.put("CODE_OBJET_LISTE", b.objet);
		}
		final Hashtable<String, String> table = new Hashtable<>();
		table.put(" ", "");
		String nomObjet = null;
		for (final Objetpartage objet : ReferentielObjets.getObjetsPartagesTries()) {
			if (! objet.isCollaboratif()) {
				table.put(objet.getNomObjet(), objet.getLibelleObjet());
			}
		}
		infoBean.put("LISTE_OBJET_LISTE", table);
	}

	@Override
	public void traiterPRINCIPAL(final Map<String, Object> infoBean, final BeanPageAccueil bean) throws Exception {
		final BeanListeFichePageAccueil b = (BeanListeFichePageAccueil) bean;
		final String codeObjet = (String) infoBean.get("CODE_OBJET_LISTE");
		if (StringUtils.isEmpty(codeObjet) || ReferentielObjets.instancierFiche(codeObjet) == null) {
			throw new ErreurApplicative(MessageHelper.getCoreMessage("RUBRIQUE.PAGE_TETE.ERREUR.OBJET_OBLIGATOIRE"));
		}
		b.objet = (String) infoBean.get("CODE_OBJET_LISTE");
	}
}
