/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.rubrique;

import java.io.File;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kportal.core.webapp.WebAppUtil;

public final class PageAccueilRubriqueHelper {

	private static final Logger LOGGER = LoggerFactory.getLogger(PageAccueilRubriqueHelper.class);

	/**
	 * Permet d'inclure la jsp de saisie d'une page d'acceuil de rubrique
	 * 
	 * @param out
	 * @param context
	 * @param request
	 * @param response
	 * @param pageAccueil
	 */
	public static void includeJspBO(final JspWriter out, final ServletContext context, final HttpServletRequest request, final HttpServletResponse response,
		final IPageAccueilRubrique pageAccueil) {
		String relativePath = pageAccueil.getPathSaisieBO();
		if (StringUtils.isNotEmpty(relativePath)) {
			// on teste d'abord l'existence du fichier à la racine de la webapp
			if (!new File(WebAppUtil.getAbsolutePath() + relativePath).exists()) {
				// on teste ensuite à la racine de l'extension
				relativePath = pageAccueil.getExtension().getRelativePath() + relativePath;
				if (!new File(WebAppUtil.getAbsolutePath() + relativePath).exists()) {
					relativePath = StringUtils.EMPTY;
				}
			}
			if (StringUtils.isNotEmpty(relativePath)) {
				try {
					out.flush();
					context.getRequestDispatcher(relativePath).include(request, response);
					out.flush();
				} catch (final Exception e) {
					LOGGER.error(e.getMessage(), e);
				}
			}
		}
	}
}
