/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.rubrique;

import java.util.Hashtable;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.objetspartages.om.ServiceBean;
import com.univ.utils.ContexteUtil;
import com.univ.utils.ServicesUtil;

public class ServicePageAccueilRubrique extends DefaultPageAccueilRubrique {

	/**
	 *
	 */
	private static final long serialVersionUID = 7746055689577755034L;

	public static class BeanServicePageAccueil implements BeanPageAccueil {

		private String code = "";

		@Override
		public String getUrlRubrique(final String codeRubrique, final String langue, final boolean ampersands) throws Exception {
			final ServiceBean service = ServicesUtil.getService(code);
			if (service != null) {
				return ServicesUtil.determinerUrlServiceTypeUrl(ContexteUtil.getContexteUniv(), service);
			}
			return StringUtils.EMPTY;
		}

		@Override
		public String getUrlModification(final String codeRubrique, final String langue, final boolean ampersands) throws Exception {
			return WebAppUtil.SG_PATH + "?EXT=core&PROC=SAISIE_PREFERENCES&ACTION=MODIFIERPARCODE&CODE_SERVICE=" + code;
		}

		@Override
		public String getLibelleAffichable() {
			String libelle = "";
			try {
				final ServiceBean service = ServicesUtil.getService(code);
				libelle += service.getIntitule();
			} catch (final Exception e) {
				libelle += "Inconnu";
			}
			return libelle;
		}

		public String getCode() {
			return code;
		}
	}

	@Override
	public void preparerPRINCIPAL(final Map<String, Object> infoBean, final BeanPageAccueil bean) throws Exception {
		final BeanServicePageAccueil b = (BeanServicePageAccueil) bean;
		if (StringUtils.isNotEmpty(b.code)) {
			infoBean.put("CODE_SERVICE", b.code);
		}
		final Hashtable<String, String> table = new Hashtable<>();
		table.put(" ", "");
		for (final ServiceBean service : ServicesUtil.getServices().values()) {
			table.put(service.getCode(), service.getIntitule());
		}
		infoBean.put("LISTE_SERVICES", table);
	}

	@Override
	public void traiterPRINCIPAL(final Map<String, Object> infoBean, final BeanPageAccueil bean) throws Exception {
		final BeanServicePageAccueil b = (BeanServicePageAccueil) bean;
		final String codeService = (String) infoBean.get("CODE_SERVICE");
		if (StringUtils.isEmpty(codeService)) {
			throw new ErreurApplicative(MessageHelper.getCoreMessage("RUBRIQUE.PAGE_TETE.ERREUR.SERVICE_OBLIGATOIRE"));
		}
		b.code = (String) infoBean.get("CODE_SERVICE");
	}

	@Override
	public boolean isInterne(final BeanPageAccueil bean) {
		if (bean instanceof BeanServicePageAccueil) {
			try {
				final ServiceBean service = ServicesUtil.getService(((BeanServicePageAccueil) bean).getCode());
				if (service != null) {
					// pas de vue réduite on regarde l'url
					if (service.getVueReduiteType().equals("0")) {
						return !service.getUrl().startsWith("http");
					} else {
						return (StringUtils.isNotEmpty(service.getVueReduiteCtx()));
					}
				}
			} catch (final Exception e) {
				// nothing
			}
		}
		return super.isInterne(bean);
	}
}
