/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.rubrique;

import java.util.Map;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.MessageHelper;

public class UrlPageAccueilRubrique extends DefaultPageAccueilRubrique {

	/**
	 *
	 */
	private static final long serialVersionUID = 6741876413479873359L;

	public static class BeanUrlPageAccueil implements BeanPageAccueil {

		private String url = "";

		@Override
		public String getUrlRubrique(final String codeRubrique, final String langue, final boolean ampersands) throws Exception {
			return url;
		}

		@Override
		public String getUrlModification(final String codeRubrique, final String langue, final boolean ampersands) throws Exception {
			return "";
		}

		@Override
		public String getLibelleAffichable() {
			return url;
		}

		public String getUrl() {
			return url;
		}
	}

	@Override
	public void preparerPRINCIPAL(final Map<String, Object> infoBean, final BeanPageAccueil bean) throws Exception {
		final BeanUrlPageAccueil b = (BeanUrlPageAccueil) bean;
		infoBean.put("URL", b.url);
	}

	@Override
	public void traiterPRINCIPAL(final Map<String, Object> infoBean, final BeanPageAccueil bean) throws Exception {
		final BeanUrlPageAccueil b = (BeanUrlPageAccueil) bean;
		if (((String) infoBean.get("URL")).length() == 0) {
			throw new ErreurApplicative(MessageHelper.getCoreMessage("RUBRIQUE.PAGE_TETE.ERREUR.URL_OBLIGATOIRE"));
		}
		b.url = (String) infoBean.get("URL");
	}
}
