/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.toolbox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.kportal.core.autorisation.ActionPermission;
import com.kportal.core.autorisation.Permission;
import com.kportal.extension.module.DefaultModuleImpl;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;

public class DefaultPluginToolbox extends DefaultModuleImpl implements IPluginToolbox {

	public String path = "";

	public Map<String, String> options = new HashMap<String, String>();

	public List<String> processus = new ArrayList<String>();

	@Override
	public List<String> getProcessus() {
		return processus;
	}

	public void setProcessus(List<String> processus) {
		this.processus = processus;
	}

	@Override
	public Map<String, String> getOptions() {
		return options;
	}

	public void setOptions(Map<String, String> options) {
		this.options = options;
	}

	@Override
	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getRelativePath() {
		return PluginToolboxHelper.getRelativePath(this);
	}

	@Override
	public boolean isAccessible() {
		boolean res = Boolean.TRUE;
		bouclePermission: for (Permission permission : getPermissions()) {
			res = Boolean.FALSE;
			ContexteUniv ctx = ContexteUtil.getContexteUniv();
			if (ctx != null && ctx.getAutorisation() != null) {
				if (!permission.getActions().isEmpty()) {
					for (ActionPermission action : permission.getActions()) {
						PermissionBean permissionBean = new PermissionBean(permission.getId(), permission.getCode(), action.getCode());
						if (ctx.getAutorisation().getListePermissions().get(permissionBean.getChaineSerialisee()) == null) {
							break bouclePermission;
						}
					}
				} else {
					PermissionBean permissionBean = new PermissionBean(permission.getId(), permission.getCode(), "");
					if (ctx.getAutorisation().getListePermissions().get(permissionBean.getChaineSerialisee()) == null) {
						break;
					}
				}
				res = Boolean.TRUE;
			}
		}
		return res;
	}
}
