/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.plugin.toolbox;

import java.util.Collection;
import java.util.Map;

import com.kportal.extension.module.AbstractBeanManager;
import com.kportal.tag.util.ContexteTagUtil;

public class PluginTagManager extends AbstractBeanManager {

	/** The Constant ID_BEAN. */
	public static final String ID_BEAN = "pluginTagToolboxManager";

	private Map<String, Collection<IPluginTag>> tagsParType;

	public Map<String, Collection<IPluginTag>> getTagsParType() {
		return tagsParType;
	}

	@Override
	public void refresh() {
		final Collection<IPluginTag> tagsDeclares = moduleManager.getModules(IPluginTag.class);
		tagsParType = ContexteTagUtil.getTagsParContexte(tagsDeclares);
	}
}
