/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service;

import java.util.Collection;

import com.kosmos.usinesite.reference.ServiceBeanReference;
import com.kportal.extension.module.IModule;

/**
 * Service Permettant d'exporter/importer/supprimer des contenus modules (fiches, rubriques, formulaire...)
 * 
 * @author olivier.camon
 * 
 */
public interface ServiceContenuModule {

	/**
	 * A quel type de contenu correspond le module (technique : rubrique; Fiche, Plugin de fiche ...; Autre : module formulaire...)
	 * 
	 * @author olivier.camon
	 * 
	 */
	public enum TypeContenu {
		TECHNIQUE, FICHE, AUTRE_CONTENU
	}

	/**
	 * Méthode d'intialisation du service. Sert principalement à initialiser la liste des modules du service.
	 */
	public void init();

	/**
	 * @return le type du contenu du service
	 */
	public TypeContenu getTypeContenu();

	/**
	 * 
	 * @return la liste des modules concernés par ce service
	 */
	public Collection<? extends IModule> getModules();

	/**
	 * 
	 * @return Le service d'export concernant ces modules
	 */
	public ServiceBeanExport<?> getServiceBeanExport();

	public String[] recupereParamsExport(IModule moduleAExporter, Collection<IModule> modulesExporter);

	/**
	 * 
	 * @return Le service d'import concernant ces modules
	 */
	public ServiceBeanImport<?> getServiceBeanImport();

	/**
	 * 
	 * @return Le service de suppression concernant ces modules
	 */
	public ServiceBeanDeletion getServiceBeanDeletion();

	/**
	 * 
	 * @return Le service de référence concernant ces modules
	 */
	public ServiceBeanReference getServiceBeanReference();

}
