/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kosmos.usinesite.reference.ModuleReference;
import com.kportal.cms.objetspartages.ReferentielManager;
import com.kportal.extension.ExtensionHelper;
import com.kportal.extension.IExtension;

public class ServiceContenuModuleManager implements Observer {

	public static final String ID_BEAN = "serviceContenuModuleManager";

	private Collection<ServiceContenuModule> servicesContenus;

	private Collection<ModuleReference> modulesReferences;

	private ReferentielManager referentielManager;

	public void setReferentielManager(final ReferentielManager referentielManager) {
		this.referentielManager = referentielManager;
	}

	public void init() {
		referentielManager.addObserver(this);
	}

	@Override
	public void update(final Observable o, final Object arg) {
		refresh();
	}

	public void refresh() {
		servicesContenus = new ArrayList<>();
		for (final IExtension extension : ExtensionHelper.getExtensionManager().getExtensions().values()) {
			final Map<String, ServiceContenuModule> servicesContenusAMettreAJour = ApplicationContextManager.getBeansOfType(extension.getId(), ServiceContenuModule.class);
			for (final ServiceContenuModule serviceContenu : servicesContenusAMettreAJour.values()) {
				serviceContenu.init();
				servicesContenus.add(serviceContenu);
			}
		}
		modulesReferences = new ArrayList<>();
		for (final IExtension extension : ExtensionHelper.getExtensionManager().getExtensions().values()) {
			final Map<String, ModuleReference> modulesFicheReference = ApplicationContextManager.getBeansOfType(extension.getId(), ModuleReference.class);
			for (final ModuleReference module : modulesFicheReference.values()) {
				module.init();
				modulesReferences.add(module);
			}
		}
	}

	public Collection<ServiceContenuModule> getServiceContenuModules() {
		return servicesContenus;
	}

	public Collection<ModuleReference> getModulesReferences() {
		return modulesReferences;
	}
}
