/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service.impl;

import java.util.Collection;

import com.kosmos.usinesite.reference.ServiceBeanReference;
import com.kportal.extension.module.IModule;
import com.kportal.extension.module.service.ServiceBeanDeletion;
import com.kportal.extension.module.service.ServiceBeanExport;
import com.kportal.extension.module.service.ServiceBeanImport;
import com.kportal.extension.module.service.ServiceContenuModule;

public class DefaultServiceContenuModule implements ServiceContenuModule {

	protected Collection<? extends IModule> modules;

	private ServiceBeanExport<?> serviceBeanExport;

	private ServiceBeanImport<?> serviceBeanImport;

	private ServiceBeanDeletion serviceBeanDeletion;

	private ServiceBeanReference serviceBeanReference;

	public void setModules(final Collection<IModule> modules) {
		this.modules = modules;
	}

	@Override
	public Collection<? extends IModule> getModules() {
		return modules;
	}

	public void setServiceBeanExport(final ServiceBeanExport<?> serviceBeanExport) {
		this.serviceBeanExport = serviceBeanExport;
	}

	@Override
	public ServiceBeanExport<?> getServiceBeanExport() {
		return serviceBeanExport;
	}

	public void setServiceBeanImport(final ServiceBeanImport<?> serviceBeanImport) {
		this.serviceBeanImport = serviceBeanImport;
	}

	@Override
	public ServiceBeanImport<?> getServiceBeanImport() {
		return serviceBeanImport;
	}

	public void setServiceBeanDeletion(final ServiceBeanDeletion serviceBeanDeletion) {
		this.serviceBeanDeletion = serviceBeanDeletion;
	}

	@Override
	public ServiceBeanDeletion getServiceBeanDeletion() {
		return serviceBeanDeletion;
	}

	public void setServiceBeanReference(final ServiceBeanReference serviceBeanReference) {
		this.serviceBeanReference = serviceBeanReference;
	}

	@Override
	public ServiceBeanReference getServiceBeanReference() {
		return serviceBeanReference;
	}

	@Override
	public void init() {}

	@Override
	public TypeContenu getTypeContenu() {
		return TypeContenu.AUTRE_CONTENU;
	}

	@Override
	public String[] recupereParamsExport(final IModule moduleAExporter, final Collection<IModule> modulesExporter) {
		return new String[] {};
	}
}
