/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service.impl;

import java.util.Collection;

import org.apache.commons.lang3.ArrayUtils;

import com.kportal.cms.objetspartages.Objetpartage;
import com.kportal.extension.module.IModule;
import com.univ.objetspartages.om.ReferentielObjets;

public class FicheServiceContenuModule extends DefaultServiceContenuModule {

	@Override
	public void init() {
		modules = ReferentielObjets.getObjetsPartagesTries();
	}

	@Override
	public TypeContenu getTypeContenu() {
		return TypeContenu.FICHE;
	}

	@Override
	public String[] recupereParamsExport(final IModule moduleAExporter, final Collection<IModule> modules) {
		String[] paramsExport = null;
		if (modules.contains(moduleAExporter)) {
			paramsExport = ArrayUtils.add(paramsExport, ((Objetpartage) moduleAExporter).getCodeObjet());
		}
		return paramsExport;
	}
}
