/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service.impl.beandeletion;

import java.sql.PreparedStatement;
import java.util.Collection;

import com.kportal.extension.module.service.ServiceBeanDeletion;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.criterespecifique.ConditionHelper;

public class ServiceBeanDeletionEncadre implements ServiceBeanDeletion {

	private static final String DELETE_WHERE_CODE_IN = "DELETE FROM ENCADRE WHERE ";

	@Override
	public void deleteByRubrique(final Collection<String> codesRubrique, final String... params) throws Exception {

		final String reqDeleteRessource = DELETE_WHERE_CODE_IN + ConditionHelper.in("CODE_RUBRIQUE", codesRubrique).formaterCondition();
		try (final ContexteDao ctx = new ContexteDao();
			 PreparedStatement stmt = ctx.getConnection().prepareStatement(reqDeleteRessource)) {
			stmt.executeUpdate();
		}
	}
}
