/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service.impl.beandeletion;

import java.util.Collection;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.extension.module.service.ServiceBeanDeletion;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.ContexteDao;
import com.univ.utils.FicheUnivMgr;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;

public class ServiceBeanDeletionFiche implements ServiceBeanDeletion {

	@Override
	public void deleteByRubrique(final Collection<String> codesRubrique, final String... params) throws Exception {
		if (params == null || StringUtils.isEmpty(params[0])) {
			throw new ErreurApplicative("impossible de supprimer les fiches des rubriques sans spécifier le type de fiche à supprimer");
		}
		final Metatag metatag = new Metatag();
		metatag.init();
		final ClauseWhere where = new ClauseWhere();
		where.setPremiereCondition(ConditionHelper.in("T1.META_CODE_RUBRIQUE", codesRubrique));
		where.and(ConditionHelper.egalVarchar("T1.META_CODE_OBJET", params[0]));
		try (ContexteDao ctxMeta = new ContexteDao()) {
			metatag.setCtx(ctxMeta);
			metatag.select(where.formaterSQL());
			while (metatag.nextItem()) {
				try (ContexteDao ctxFiche = new ContexteDao()) {
					final FicheUniv fiche = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(metatag.getMetaCodeObjet()));
					fiche.setCtx(ctxFiche);
					fiche.setIdFiche(metatag.getMetaIdFiche());
					fiche.retrieve();
					FicheUnivMgr.supprimerFiche(fiche, metatag);
				}
			}
		}
	}
}
