/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service.impl.beanexport;

import java.util.List;

import com.kosmos.usinesite.utils.UASOmHelper;
import com.kosmos.usinesite.utils.UASServicesHelper;
import com.kportal.extension.module.bean.BeanExportMap;
import com.kportal.extension.module.bean.EncadreBeanExport;
import com.kportal.extension.module.service.ServiceBeanExport;
import com.univ.objetspartages.bean.EncadreBean;
import com.univ.objetspartages.om.Encadre;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;

public class ServiceBeanExportEncadre implements ServiceBeanExport<EncadreBeanExport> {

	@Override
	public BeanExportMap<EncadreBeanExport> getBeansByRubrique(final List<String> codesRubrique, final String idModule, final String pathExport, final String... params)
		throws Exception {
		final BeanExportMap<EncadreBeanExport> encadres = new BeanExportMap<>();
		try (ContexteDao ctx = new ContexteDao()) {
			final Encadre encadre = new Encadre();
			encadre.setCtx(ctx);
			final RequeteSQL requete = new RequeteSQL();
			final ClauseWhere where = new ClauseWhere();
			where.setPremiereCondition(ConditionHelper.in("CODE_RUBRIQUE", codesRubrique));
			requete.where(where);
			encadre.select(requete.formaterRequete());
			while (encadre.nextItem()) {
				final EncadreBeanExport encadreBeanExport = new EncadreBeanExport();
				// on préfixe le titre pour le retrouver facilement dans la liste
				final EncadreBean encadreBean = new EncadreBean();
				UASOmHelper.copyProperties(encadreBean, encadre);
				encadreBeanExport.setIdModule(idModule);
				encadre.setIntitule(encadre.getIntitule());
				encadreBeanExport.setBean(encadreBean);
				encadreBeanExport.setMedias(UASServicesHelper.getMedias(ctx, encadre, pathExport));
				encadres.put(encadre.getCode(), encadreBeanExport);
			}
		}
		return encadres;
	}
}
