/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service.impl.beanexport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import com.kosmos.usinesite.utils.UASServicesHelper;
import com.kportal.extension.module.bean.BeanExportMap;
import com.kportal.extension.module.bean.PluginFicheBeanExport;
import com.kportal.extension.module.plugin.objetspartages.om.ObjetPluginContenu;
import com.kportal.extension.module.plugin.objetspartages.om.SousObjet;
import com.kportal.extension.module.service.ServiceBeanExport;
import com.kportal.extension.module.service.impl.PluginFicheServiceContenuModule;
import com.univ.objetspartages.om.Metatag;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;

public class ServiceBeanExportPluginFiche implements ServiceBeanExport<PluginFicheBeanExport<?>> {

	@SuppressWarnings("deprecation")
	@Override
	public BeanExportMap<PluginFicheBeanExport<?>> getBeansByRubrique(final List<String> codesRubrique, final String idModule, final String pathExport, final String... params)
		throws Exception {
		final BeanExportMap<PluginFicheBeanExport<?>> pluginFichesBeans = new BeanExportMap<>();
		if (ArrayUtils.isNotEmpty(params)) {
			final List<String> codesObjet = new ArrayList<>();
			final List<String> classes = new ArrayList<>();
			for (final String param : params) {
				if (param.startsWith(PluginFicheServiceContenuModule.PARAM_META_CODE_OBJET)) {
					codesObjet.add(StringUtils.substringAfter(param, PluginFicheServiceContenuModule.PARAM_META_CODE_OBJET));
				} else if (param.startsWith(PluginFicheServiceContenuModule.PARAM_CLASSE)) {
					classes.add(StringUtils.substringAfter(param, PluginFicheServiceContenuModule.PARAM_CLASSE));
				}
			}
			if (CollectionUtils.isNotEmpty(classes)) {
				try (ContexteDao ctx = new ContexteDao()) {
					final Collection<String> idsMeta = new ArrayList<>();
					final Metatag metatag = new Metatag();
					metatag.init();
					metatag.setCtx(ctx);
					RequeteSQL requete = new RequeteSQL();
					ClauseWhere where = new ClauseWhere();
					where.setPremiereCondition(ConditionHelper.in("T1.META_CODE_RUBRIQUE", codesRubrique));
					if (CollectionUtils.isNotEmpty(codesObjet)) {
						where.and(ConditionHelper.in("T1.META_CODE_OBJET", codesObjet));
					}
					requete.where(where);
					metatag.select(requete.formaterRequete());
					while (metatag.nextItem()) {
						idsMeta.add(metatag.getIdMetatag().toString());
					}
					for (final String classeObjet : classes) {
						final Class<?> clazz = Class.forName(classeObjet);
						final Object object = clazz.newInstance();
						if (object instanceof ObjetPluginContenu) {
							final ObjetPluginContenu objetPluginContenu = (ObjetPluginContenu) object;
							objetPluginContenu.init();
							objetPluginContenu.setCtx(ctx);
							requete = new RequeteSQL();
							where = new ClauseWhere();
							where.setPremiereCondition(ConditionHelper.in("T1.ID_META", idsMeta));
							requete.where(where);
							objetPluginContenu.select(requete.formaterRequete());
							while (objetPluginContenu.nextItem()) {
								final PluginFicheBeanExport<?> beanExport = UASServicesHelper.getPluginFicheBeanExport(objetPluginContenu,
										UASServicesHelper.getBeanClass(objetPluginContenu));
								beanExport.setClasseObjet(classeObjet);
								beanExport.setIdModule(idModule);
								beanExport.setMedias(UASServicesHelper.getMedias(ctx, objetPluginContenu, pathExport));
								pluginFichesBeans.put(objetPluginContenu.getIdObjet().toString(), beanExport);
								if (CollectionUtils.isNotEmpty(objetPluginContenu.getSousObjets())) {
									for (final SousObjet sousObjet : objetPluginContenu.getSousObjets()) {
										final PluginFicheBeanExport<SousObjet> beanExportSousObjet = new PluginFicheBeanExport<>();
										final String saveId = sousObjet.getIdObjet().toString();
										sousObjet.setIdObjet((long) 0);
										beanExportSousObjet.setBean(sousObjet);
										beanExportSousObjet.setIdModule(idModule);
										beanExportSousObjet.setClasseObjet(sousObjet.getClass().getName());
										beanExportSousObjet.setMedias(UASServicesHelper.getMedias(ctx, sousObjet, pathExport));
										// les plugins et leurs sous objets sont stockes dans la même map, on préfixe l'id par le nom de la classe
										pluginFichesBeans.put(sousObjet.getClass().getSimpleName() + saveId, beanExportSousObjet);
									}
								}
							}
							// TODO export des ressources et medias quand on aura la possibilité d'en ajouter sur tous les objets hors fiche
						}
					}
				}
			}
		}
		return pluginFichesBeans;
	}
}
