/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service.impl.beanexport;

import java.util.List;

import com.kosmos.usinesite.utils.UASOmHelper;
import com.kosmos.usinesite.utils.UASServicesHelper;
import com.kportal.extension.module.bean.BeanExportMap;
import com.kportal.extension.module.bean.RubriqueBeanExport;
import com.kportal.extension.module.service.ServiceBeanExport;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.bean.RubriqueBean;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteDao;
import com.univ.utils.sql.RequeteSQL;
import com.univ.utils.sql.clause.ClauseWhere;
import com.univ.utils.sql.criterespecifique.ConditionHelper;

public class ServiceBeanExportRubrique implements ServiceBeanExport<RubriqueBeanExport> {

	@Override
	public BeanExportMap<RubriqueBeanExport> getBeansByRubrique(final List<String> codesRubrique, final String idModule, final String pathExport, final String... params)
		throws Exception {
		final BeanExportMap<RubriqueBeanExport> rubriqueBeans = new BeanExportMap<>();
		try (ContexteDao ctx = new ContexteDao()) {
			final Rubrique rubrique = new Rubrique();
			rubrique.setCtx(ctx);
			final RequeteSQL requete = new RequeteSQL();
			final ClauseWhere where = new ClauseWhere();
			where.setPremiereCondition(ConditionHelper.in("CODE", codesRubrique));
			requete.where(where);
			rubrique.select(requete.formaterRequete());
			while (rubrique.nextItem()) {
				final RubriqueBean rubriqueBean = new RubriqueBean();
				final RubriqueBeanExport rubriqueBeanExport = new RubriqueBeanExport();
				final InfosSite infos = Site.renvoyerItemSiteParRubrique(rubrique.getCode());
				if (infos != null) {
					rubriqueBeanExport.setRubriqueSite(true);
				}
				UASOmHelper.copyProperties(rubriqueBean, rubrique);
				rubriqueBeanExport.setIdModule(idModule);
				rubriqueBeanExport.setBean(rubriqueBean);
				rubriqueBeanExport.setMedias(UASServicesHelper.getMedias(ctx, rubrique, pathExport));
				rubriqueBeans.put(rubrique.getCode(), rubriqueBeanExport);
			}
		}
		return rubriqueBeans;
	}
}
