/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service.impl.beanimport;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kosmos.usinesite.utils.UASOmHelper;
import com.kportal.extension.module.bean.AbstractBeanExport;
import com.kportal.extension.module.bean.EncadreBeanExport;
import com.kportal.extension.module.service.ServiceBeanImport;
import com.univ.objetspartages.bean.EncadreBean;
import com.univ.objetspartages.om.Encadre;
import com.univ.utils.ContexteDao;

public class ServiceBeanImportEncadre implements ServiceBeanImport<EncadreBeanExport> {

	private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBeanImportEncadre.class);

	@Override
	public String importBeanExport(final AbstractBeanExport<?> beanExport, final String pathImport) {
		final EncadreBeanExport encadreBeanExport = (EncadreBeanExport) beanExport;
		try (ContexteDao contexteDao = new ContexteDao()) {
			addEncadre(contexteDao, encadreBeanExport.getBean());
			UASOmHelper.addAllMediaBean(contexteDao, encadreBeanExport.getMedias(), pathImport);
		} catch (final Exception e) {
			LOGGER.error(String.format("Une erreur est survenue lors de l'import de l'encadre \"%s\"", encadreBeanExport), e);
		}
		return null;
	}

	private void addEncadre(final ContexteDao contexteDao, final EncadreBean encadreBean) throws Exception {
		final Encadre encadre = new Encadre();
		encadre.init();
		encadre.setCtx(contexteDao);
		UASOmHelper.copyProperties(encadre, encadreBean);
		encadre.add();
	}
}
