/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service.impl.beanimport;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kosmos.usinesite.utils.UASOmHelper;
import com.kportal.extension.module.bean.AbstractBeanExport;
import com.kportal.extension.module.bean.FicheBeanExport;
import com.kportal.extension.module.service.ServiceBeanImport;
import com.univ.objetspartages.bean.RubriquepublicationBean;
import com.univ.objetspartages.om.AbstractFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.Rubriquepublication;
import com.univ.utils.ContexteDao;

public class ServiceBeanImportFiche implements ServiceBeanImport<FicheBeanExport<?>> {

	/** Logger available to subclasses. */
	private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBeanImportFiche.class);

	@Override
	public String importBeanExport(final AbstractBeanExport<?> beanExport, final String pathImport) {
		final FicheBeanExport<?> ficheBeanExport = (FicheBeanExport<?>) beanExport;
		try (ContexteDao contexteDao = new ContexteDao()) {
			UASOmHelper.addMetatagBean(contexteDao, ficheBeanExport.getMetatag());
			addFicheUniv(contexteDao, ficheBeanExport);
			UASOmHelper.addAllRessourceMediaBean(contexteDao, ficheBeanExport.getRessources(), ficheBeanExport.getMedias(), pathImport);
			addRubriquePublication(contexteDao, ficheBeanExport);
		} catch (final Exception e) {
			LOGGER.error(String.format("Une erreur est survenue lors de l'import de la fiche \"%s\"", ficheBeanExport), e);
		}
		return null;
	}

	private void addFicheUniv(final ContexteDao contexteDao, final FicheBeanExport<?> ficheBeanExport) throws Exception {
		final FicheUniv fiche = ReferentielObjets.instancierFiche(ficheBeanExport.getTypeObjet());
		fiche.init();
		fiche.setCtx(contexteDao);
		if (fiche instanceof AbstractFiche) {
			final AbstractFiche<?> finalFiche = (AbstractFiche<?>) fiche;
			UASOmHelper.copyProperties(finalFiche.getPersistenceBean(), ficheBeanExport.getBean());
		} else {
			UASOmHelper.copyProperties(fiche, ficheBeanExport.getBean());
		}
		fiche.add();
	}

	private void addRubriquePublication(final ContexteDao contexteDao, final FicheBeanExport<?> ficheBeanExport) throws Exception {
		if (CollectionUtils.isNotEmpty(ficheBeanExport.getRubriquespublication())) {
			for (final RubriquepublicationBean currentRubriquepublicationBean : ficheBeanExport.getRubriquespublication()) {
				final Rubriquepublication rubriquePublication = new Rubriquepublication();
				rubriquePublication.init();
				rubriquePublication.setCtx(contexteDao);
				UASOmHelper.copyProperties(rubriquePublication, currentRubriquepublicationBean);
				rubriquePublication.add();
			}
		}
	}
}
