/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service.impl.beanimport;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kosmos.usinesite.utils.UASOmHelper;
import com.kportal.extension.module.bean.AbstractBeanExport;
import com.kportal.extension.module.bean.PluginFicheBeanExport;
import com.kportal.extension.module.plugin.objetspartages.om.ObjetPluginContenu;
import com.kportal.extension.module.plugin.objetspartages.om.SousObjet;
import com.kportal.extension.module.service.ServiceBeanImport;
import com.univ.objetspartages.om.AbstractOm;
import com.univ.utils.ContexteDao;

public class ServiceBeanImportPluginFiche implements ServiceBeanImport<PluginFicheBeanExport<?>> {

	/** Logger available to subclasses. */
	private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBeanImportPluginFiche.class);

	@SuppressWarnings("deprecation")
	@Override
	public String importBeanExport(final AbstractBeanExport<?> beanExport, final String pathImport) {
		final PluginFicheBeanExport<?> pluginFicheBeanExport = (PluginFicheBeanExport<?>) beanExport;
		try (ContexteDao contexteDao = new ContexteDao()) {
			final Class<?> clazz = Class.forName(pluginFicheBeanExport.getClasseObjet());
			final Object object = clazz.newInstance();
			if (object instanceof ObjetPluginContenu) {
				final ObjetPluginContenu objetPluginContenu = (ObjetPluginContenu) object;
				objetPluginContenu.init();
				objetPluginContenu.setCtx(contexteDao);
				if (objetPluginContenu instanceof AbstractOm<?, ?>) {
					final AbstractOm<?, ?> finalFiche = (AbstractOm<?, ?>) objetPluginContenu;
					UASOmHelper.copyProperties(finalFiche.getPersistenceBean(), pluginFicheBeanExport.getBean());
				} else {
					UASOmHelper.copyProperties(objetPluginContenu, pluginFicheBeanExport.getBean());
				}
				objetPluginContenu.add();
			}
			if (object instanceof SousObjet) {
				final SousObjet sousObjet = (SousObjet) object;
				sousObjet.init();
				sousObjet.setCtx(contexteDao);
				if (sousObjet instanceof AbstractOm<?, ?>) {
					final AbstractOm<?, ?> finalFiche = (AbstractOm<?, ?>) sousObjet;
					UASOmHelper.copyProperties(finalFiche.getPersistenceBean(), pluginFicheBeanExport.getBean());
				} else {
					UASOmHelper.copyProperties(sousObjet, pluginFicheBeanExport.getBean());
				}
				sousObjet.add();
			}
			UASOmHelper.addAllRessourceMediaBean(contexteDao, pluginFicheBeanExport.getRessources(), pluginFicheBeanExport.getMedias(), pathImport);
		} catch (final Exception e) {
			LOGGER.error(String.format("Une erreur est survenue lors de l'import de la fiche \"%s\"", pluginFicheBeanExport), e);
		}
		return null;
	}
}
