/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.module.service.impl.beanimport;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kosmos.usinesite.utils.UASOmHelper;
import com.kportal.extension.module.bean.AbstractBeanExport;
import com.kportal.extension.module.bean.RubriqueBeanExport;
import com.kportal.extension.module.service.ServiceBeanImport;
import com.univ.objetspartages.bean.RubriqueBean;
import com.univ.objetspartages.om.Rubrique;
import com.univ.utils.ContexteDao;

public class ServiceBeanImportRubrique implements ServiceBeanImport<RubriqueBeanExport> {

	private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBeanImportRubrique.class);

	@Override
	public String importBeanExport(final AbstractBeanExport<?> beanExport, final String pathImport) {
		final RubriqueBeanExport rubriqueBeanExport = (RubriqueBeanExport) beanExport;
		try (ContexteDao contexteDao = new ContexteDao()) {
			addRubrique(contexteDao, rubriqueBeanExport.getBean(), rubriqueBeanExport.isRubriqueSite());
			UASOmHelper.addAllMediaBean(contexteDao, rubriqueBeanExport.getMedias(), pathImport);
		} catch (final Exception e) {
			LOGGER.error(String.format("Une erreur est survenue lors de l'import de la rubrique \"%s\"", rubriqueBeanExport), e);
		}
		if (rubriqueBeanExport.isRubriqueSite()) {
			return rubriqueBeanExport.getBean().getCode();
		} else {
			return null;
		}
	}

	private void addRubrique(final ContexteDao contexteDao, final RubriqueBean rubriqueBean, final boolean isRubriqueSite) throws Exception {
		final Rubrique rubrique = new Rubrique();
		rubrique.init();
		rubrique.setCtx(contexteDao);
		UASOmHelper.copyProperties(rubrique, rubriqueBean);
		if (isRubriqueSite) {
			rubrique.setIntitule(String.format("%s [Copie]", rubrique.getIntitule()));
		}
		rubrique.add();
	}
}
