/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.extension.service;

import java.sql.PreparedStatement;
import java.sql.Timestamp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.univ.utils.ContexteDao;

public class EtatModuleHelper {

	private static final Logger LOG = LoggerFactory.getLogger(EtatModuleHelper.class);

	public static void setEtatDB(final int etatARestaurer, final Long idExtension) {
		PreparedStatement statement;
		try (ContexteDao ctx = new ContexteDao()) {
			String requete = "UPDATE MODULE SET ETAT = ?, DATE_MODIFICATION = ? ";
			if (idExtension != null) {
				requete += "WHERE ID_EXTENSION = ? ";
			}
			statement = ctx.getConnection().prepareStatement(requete);
			statement.setInt(1, etatARestaurer);
			statement.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
			if (idExtension != null) {
				statement.setLong(3, idExtension);
			}
			statement.execute();
			statement.close();
		} catch (final Exception e) {
			LOG.error("erreur lors de la requête sql", e);
		}
	}
}
