/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 24 nov. 2006
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.kportal.frontoffice;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import javax.servlet.jsp.JspWriter;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.webutils.ContextePage;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.utils.FileUtil;

// TODO: Auto-generated Javadoc
/**
 * Procédure de migration des jsp pour les méthodes obsolètes.
 *
 * @author fred
 */
public class DuplicationTemplate {

	private static Logger LOG = LoggerFactory.getLogger(DuplicationTemplate.class);

	/** The read dir. */
	private File readDir = null;

	/** The out. */
	private JspWriter out = null;

	/** The bilan. */
	private StringBuffer bilan = null;

	/** Le template jsp à remplacer **/
	private String oldTemplateJsp = "jsp";

	/** Le template jsp cible **/
	private String newTemplateJsp = "jsp_new";

	/**
	 * Migrer.
	 *
	 * @param _out
	 *            the _out
	 *
	 * @throws Exception
	 *             the exception
	 */
	public static void migrer(final JspWriter _out, final String _oldTemplateJsp, final String _newTemplateJsp) throws Exception {
		_out.println("DEBUT du traitement ...<br />");
		_out.flush();
		final String readDir = WebAppUtil.getAbsolutePath() + File.separator + _oldTemplateJsp;
		final String writeDir = WebAppUtil.getAbsolutePath() + File.separator + _newTemplateJsp;
		final File readDirFile = new File(readDir);
		if (!readDirFile.exists()) {
			_out.println("Le répertoire " + readDir + " n'existe pas.");
			return;
		}
		final File writeDirFile = new File(writeDir);
		if (writeDirFile.exists()) {
			_out.println("Le répertoire " + writeDir + " existe déjà.");
			return;
		} else {
			writeDirFile.mkdir();
		}
		final DuplicationTemplate migration = new DuplicationTemplate();
		migration.setOut(_out);
		migration.setReadDir(readDirFile);
		migration.setWriteDir(writeDirFile);
		migration.setOldTemplateJsp(_oldTemplateJsp);
		migration.setNewTemplateJsp(_newTemplateJsp);
		final ContextePage ctx = new ContextePage("");
		_out.println("<br />*** Duplication du front office ***<br />");
		migration.migrerMethodes();
		_out.println("<br /><br />FIN du traitement.");
		ctx.release();
	}

	/**
	 * Sets the read dir.
	 *
	 * @param readDir
	 *            The readDir to set.
	 */
	public void setReadDir(final File readDir) {
		this.readDir = readDir;
	}

	/**
	 * Migrer methodes.
	 */
	public void migrerMethodes() {
		try {
			bilan = new StringBuffer();
			processFile(readDir);
			printlnOut("<br /><br />*** BILAN ***", true);
			printlnOut(bilan.toString(), true);
			out.flush();
		} catch (final IOException e) {
			LOG.error("erreur lors de l'ecriture sur la sortie", e);
		}
	}

	/**
	 * Println out.
	 *
	 * @param s
	 *            the s
	 * @param system
	 *            the system
	 */
	private void printlnOut(final String s, final boolean system) {
		try {
			if (system) {
				System.out.println(s);
			}
			out.write(s);
			out.newLine();
		} catch (final IOException e) {
			LOG.error("impossible d'écrire sur la sortie", e);
		}
	}

	/**
	 * Process file.
	 *
	 * @param fRead
	 *            the f read
	 */
	private void processFile(final File fRead) {
		if (fRead.isDirectory()) {
			// creation du répertoire cible
			final String sDir = StringUtils.replace(fRead.getAbsolutePath(), File.separator + oldTemplateJsp + File.separator, File.separator + newTemplateJsp + File.separator);
			new File(sDir).mkdir();
			final File[] listFiles = fRead.listFiles();
			for (int i = 0; i < listFiles.length; i++) {
				if (!listFiles[i].isHidden()) {
					processFile(listFiles[i]);
				}
			}
		} else {
			processJsp(fRead);
		}
	}

	/**
	 * Process jsp.
	 *
	 * @param fRead
	 *            the f read
	 */
	private void processJsp(final File fRead) {
		final File fWrite = new File(fRead.getAbsolutePath() + ".tmp");
		printlnOut("<br />Traitement du fichier : " + fRead, true);
		final StringBuffer sb = new StringBuffer();
		try {
			final BufferedReader reader = new BufferedReader(new FileReader(fRead));
			final BufferedWriter writer = new BufferedWriter(new FileWriter(fWrite));
			String line = null;
			int indiceLine = 1;
			while ((line = reader.readLine()) != null) // chaque ligne
			{
				if (indiceLine > 1) {
					writer.write("\r\n");
				}
				if (line.indexOf("/" + oldTemplateJsp + "/") != -1) // si la ligne contient la référence au template
				{
					line = line.replaceAll("/" + oldTemplateJsp + "/", "/" + newTemplateJsp + "/");
				}
				writer.write(line);
				indiceLine++;
			}
			reader.close();
			writer.flush();
			writer.close();
			// copie du fichier
			final String sFile = StringUtils.replace(fRead.getAbsolutePath(), File.separator + oldTemplateJsp + File.separator, File.separator + newTemplateJsp + File.separator);
			FileUtil.copierFichier(fWrite, new File(sFile));
			fWrite.delete();
			if (sb.length() > 0) {
				bilan.append("<br /><br />Fichier : " + fRead);
				bilan.append(sb);
			}
		} catch (final IOException e) {
			LOG.error("erreur d'écriture sur le fichier", e);
		}
	}

	/**
	 * Sets the out.
	 *
	 * @param out
	 *            the new out
	 */
	public void setOut(final JspWriter out) {
		this.out = out;
	}

	public void setOldTemplateJsp(final String oldTemplateJsp) {
		this.oldTemplateJsp = oldTemplateJsp;
	}

	public void setNewTemplateJsp(final String newTemplateJsp) {
		this.newTemplateJsp = newTemplateJsp;
	}

	public void setWriteDir(final File writeDir) {}
}
