/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.ihm;

import java.beans.Introspector;
import java.io.IOException;
import java.util.Map;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.univ.url.BeanFrontManager;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;

/**
 * Filtre permettant d'initialiser les beans utiliser en FO.
 */
public class FrontOfficeFilter implements Filter {

	@Override
	public void destroy() {}

	@Override
	public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
		final String path = ((HttpServletRequest) request).getRequestURI();
		if (!StringUtils.startsWith(path, "/adminsite")) {
			final ContexteUniv ctx = ContexteUtil.getContexteUniv();
			ctx.calculerCodeRubriquePageCourante();
			final Map<String, BeanFrontManager> beansFrontParIdBean = ApplicationContextManager.getCoreContextBeansOfType(BeanFrontManager.class);
			for (final BeanFrontManager bean : beansFrontParIdBean.values()) {
				final Object beanFront = bean.initialiseBeanFront();
				final String className = beanFront.getClass().getSimpleName();
				request.setAttribute(Introspector.decapitalize(className), beanFront);
			}
		}
		chain.doFilter(request, response);
	}

	@Override
	public void init(final FilterConfig arg0) throws ServletException {}
}
