/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.ihm.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.kportal.extension.module.composant.ComposantHelper;
import com.kportal.extension.module.composant.IComposant;
import com.kportal.extension.module.composant.Menu;
import com.univ.objetspartages.om.AutorisationBean;

public class ServiceMenuBack {

	/**
	 * Récupère le menu Back Office de l'utilisateur courant et du contexte
	 *
	 * @param ctx
	 * @return
	 */
	public static Menu getMenuBackOfficeParUtilisateur(final AutorisationBean autorisation) {
		final Menu menuPrincipal = new Menu();
		final Map<String, Menu> menusPrincipaux = new HashMap<String, Menu>();
		final Collection<Menu> sousMenus = new ArrayList<Menu>();
		final Collection<IComposant> menuNonConstruit = ComposantHelper.getComposants();
		if (CollectionUtils.isNotEmpty(menuNonConstruit)) {
			for (final IComposant composant : menuNonConstruit) {
				if (composant.isVisible(autorisation)) {
					final Menu menuCourant = construitMenuDepuisComposant(composant);
					if (StringUtils.isBlank(composant.getIdMenuBoParent())) {
						menusPrincipaux.put(composant.getId(), menuCourant);
					} else {
						sousMenus.add(menuCourant);
					}
				}
			}
			for (final Menu menuCourant : sousMenus) {
				final Menu menuParent = menusPrincipaux.get(menuCourant.getIdMenuParent());
				if (menuParent != null) {
					menuParent.addSousMenu(menuCourant);
				}
			}
			for (final Menu menuCourant : menusPrincipaux.values()) {
				Collections.sort(menuCourant.getSousMenu());
			}
		}
		menuPrincipal.addAllSousMenu(menusPrincipaux.values());
		Collections.sort(menuPrincipal.getSousMenu());
		return menuPrincipal;
	}

	public static Menu construitMenuDepuisComposant(final IComposant composant) {
		final Menu menuNiveau = new Menu();
		menuNiveau.setIdMenu(composant.getId());
		menuNiveau.setCode("menu_" + composant.getId());
		menuNiveau.setIdMenuParent(composant.getIdMenuBoParent());
		menuNiveau.setLibelle(composant.getLibelleAffichable());
		menuNiveau.setOrdre(composant.getOrdre());
		menuNiveau.setUrl(StringUtils.replace(composant.getUrlAccueilBo(), "&", "&amp;"));
		return menuNiveau;
	}
}
