/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.ihm.utils.sharing;

import java.text.MessageFormat;

import org.apache.commons.lang3.StringUtils;

import com.univ.objetspartages.om.FicheUniv;
import com.univ.utils.ContexteUniv;
import com.univ.utils.URLResolver;

public class DefaultSocialNetworkUrl implements SocialNetworkUrl {

	private String socialNetworkUrl;

	private String socialNetworkName;

	public String getSocialNetworkUrl() {
		return socialNetworkUrl;
	}

	public void setSocialNetworkUrl(final String socialNetworkName) {
		this.socialNetworkUrl = socialNetworkName;
	}

	public String getSocialNetworkName() {
		return socialNetworkName;
	}

	public void setSocialNetworkName(final String socialNetworkName) {
		this.socialNetworkName = socialNetworkName;
	}

	@Override
	public String getSharingUrl(final FicheUniv fiche, final ContexteUniv ctx) {
		String urlPartage = StringUtils.EMPTY;
		if (StringUtils.isNotBlank(socialNetworkUrl)) {
			final String urlFiche = URLResolver.getAbsoluteUrlFiche(fiche, ctx);
			urlPartage = MessageFormat.format(socialNetworkUrl, urlFiche);
		}
		return urlPartage;
	}
}
