/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.pdf;

/*
 * PDFServlet.java
 *
 * Created on June 9, 2007, 10:25 PM
 */
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.lang.CharEncoding;
import com.univ.utils.ContexteUtil;

/**
 * The Class PDFServlet.
 * @deprecated cette servlet ne doit plus être appeler et sert juste pour les anciens front pour qu'ils puissent encore fonctionner.
 */
@Deprecated
public class PDFServlet extends HttpServlet {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 1L;

	private static final Logger LOG = LoggerFactory.getLogger(PDFServlet.class);


	/**
	 * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
	 * 
	 * @param request
	 *            servlet request
	 * @param response
	 *            servlet response
	 * 
	 * @throws ServletException
	 *             the servlet exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// parse our markup into an xml Document
		try {
			String sUrl = request.getParameter("URL");
			// test que l'url est bien du serveur lui même
			if (isValidUrl(sUrl, request)) {
				if (StringUtils.contains(sUrl,"?")) {
					sUrl += "&";
				} else {
					sUrl += "?";
				}
				response.sendRedirect(sUrl + PDFUtils.TO_PDF_PARAMETER + "=true");
			} else {
				response.setStatus(HttpServletResponse.SC_NOT_FOUND);
				String forward = ContexteUtil.getContexteUniv().getInfosSite().getJspFo() + "/error/404.jsp?URL_DEMANDEE=" + URLEncoder.encode(request.getRequestURI(), CharEncoding.DEFAULT);
				forwardError(request, response, forward);
			}
		} catch (Exception ex) {
			LOG.error("An error occured while generating a pdf", ex);
			response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
			String forward = ContexteUtil.getContexteUniv().getInfosSite().getJspFo() + "/error/500.jsp?URL_DEMANDEE=" + URLEncoder.encode(request.getRequestURI(), CharEncoding.DEFAULT);
			forwardError(request,response,forward);
		}
	}

	private void forwardError(HttpServletRequest request, HttpServletResponse response, String urlForward) throws ServletException, IOException {
		if (StringUtils.isNotEmpty(request.getHeader("referer"))) {
			try {
				urlForward += "&REFERER=" + URLEncoder.encode(request.getHeader("referer"), CharEncoding.DEFAULT);
			} catch (UnsupportedEncodingException ignored) {}
		}
		final javax.servlet.ServletContext context = getServletConfig().getServletContext();
		final javax.servlet.RequestDispatcher rd = context.getRequestDispatcher(urlForward);
		rd.forward(request, response);
	}

	// <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
	/**
	 * Handles the HTTP <code>GET</code> method.
	 * 
	 * @param request
	 *            servlet request
	 * @param response
	 *            servlet response
	 * 
	 * @throws ServletException
	 *             the servlet exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		processRequest(request, response);
	}

	/**
	 * Handles the HTTP <code>POST</code> method.
	 * 
	 * @param request
	 *            servlet request
	 * @param response
	 *            servlet response
	 * 
	 * @throws ServletException
	 *             the servlet exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		processRequest(request, response);
	}

	// </editor-fold>
	/**
	 * Checks if is valid url.
	 * 
	 * @param url
	 *            the url
	 * @param request
	 *            the request
	 * @return true, if is valid url
	 */
	private boolean isValidUrl(String url, HttpServletRequest request) {
		Boolean isValid = Boolean.FALSE;
		if (StringUtils.isNotEmpty(url)) {
			isValid = url.contains(request.getServerName());
			if (isValid) {
				try {
					URL currentURL = new URL(url);
				} catch (MalformedURLException e) {
					isValid = false;
				}
			}
		}
		return isValid;
	}
}
