/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.pdf;

import org.allcolor.yahp.converter.IHtmlToPdfTransformer;
import org.allcolor.yahp.converter.IHtmlToPdfTransformer.PageSize;

public class PDFproperties {

	/** The Constant ID_BEAN. */
	public static final String ID_BEAN = "pdfProperties";

	public static final String DATE_CONTENT = "<date>";

	public static final String TITLE_CONTENT = "<title>";

	public static final String URL_CONTENT = "<url>";

	public String fontsPath = "";

	public String headerHtml = "";

	public String footerHtml = "<p style=\"text-align:center\">Page <pagenumber></p>";

	public String width = "20.8";

	public String height = "29.6";

	public String lmargin = "1";

	public String rmargin = "1";

	public String bmargin = "1";

	public String tmargin = "1";

	public PageSize pageSize = IHtmlToPdfTransformer.A4P;

	public void init() {
		try {
			pageSize = new PageSize(Double.parseDouble(width + "d"), Double.parseDouble(height + "d"), Double.parseDouble(lmargin + "d"), Double.parseDouble(rmargin + "d"),
					Double.parseDouble(bmargin + "d"), Double.parseDouble(tmargin + "d"));
		} catch (Exception e) {
			// nothing
		}
	}

	public PageSize getPageSize() {
		return pageSize;
	}

	public void setPageSize(PageSize pageSize) {
		this.pageSize = pageSize;
	}

	public PDFproperties() {
		super();
	}

	public String getFontsPath() {
		return fontsPath;
	}

	public void setFontsPath(String fontPath) {
		this.fontsPath = fontPath;
	}

	public String getHeaderHtml() {
		return headerHtml;
	}

	public void setHeaderHtml(String headerHtml) {
		this.headerHtml = headerHtml;
	}

	public String getFooterHtml() {
		return footerHtml;
	}

	public void setFooterHtml(String footerHtml) {
		this.footerHtml = footerHtml;
	}

	public String getWidth() {
		return width;
	}

	public void setWidth(String width) {
		this.width = width;
	}

	public String getHeight() {
		return height;
	}

	public void setHeight(String height) {
		this.height = height;
	}

	public String getLmargin() {
		return lmargin;
	}

	public void setLmargin(String lmargin) {
		this.lmargin = lmargin;
	}

	public String getRmargin() {
		return rmargin;
	}

	public void setRmargin(String rmargin) {
		this.rmargin = rmargin;
	}

	public String getBmargin() {
		return bmargin;
	}

	public void setBmargin(String bmargin) {
		this.bmargin = bmargin;
	}

	public String getTmargin() {
		return tmargin;
	}

	public void setTmargin(String tmargin) {
		this.tmargin = tmargin;
	}
}
