/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.kportal.rubrique.util;

import java.io.File;
import java.util.Map;

import com.univ.mediatheque.Mediatheque;

/**
 * @author emmanuel clisson
 */
public class GenericRubriqueProvider extends RubriqueProvider {

	@Override
	public Map<String, RubriqueWrapper> setRubrique(File file) throws Exception {
		RubriqueProvider provider = null;
		Map<String, RubriqueWrapper> wrappers = null;
		// recherche des mime types
		String mimeType = Mediatheque.getInstance().getContentType(file.getName());
		// choix du provider
		if (mimeType.matches(XMLRubriqueProvider.XML_MIME_TYPE_PATTERN)) {
			provider = new XMLRubriqueProvider();
		} else {
			provider = null;
		}
		// si possible instanciation d'objet K-Portal
		if (provider != null) {
			wrappers = provider.setRubrique(file);
		}
		return wrappers;
	}
}
